<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InterconnectOutageNotification extends \Google\Collection
{
  /**
   * [Deprecated] The Interconnect may be completely out of service for some or
   * all of the specified window.
   */
  public const ISSUE_TYPE_IT_OUTAGE = 'IT_OUTAGE';
  /**
   * [Deprecated] Some circuits comprising the Interconnect will be out of
   * service during the expected window. The interconnect as a whole should
   * remain up, albeit with reduced bandwidth.
   */
  public const ISSUE_TYPE_IT_PARTIAL_OUTAGE = 'IT_PARTIAL_OUTAGE';
  /**
   * The Interconnect may be completely out of service for some or all of the
   * specified window.
   */
  public const ISSUE_TYPE_OUTAGE = 'OUTAGE';
  /**
   * Some circuits comprising the Interconnect will be out of service during the
   * expected window. The interconnect as a whole should remain up, albeit with
   * reduced bandwidth.
   */
  public const ISSUE_TYPE_PARTIAL_OUTAGE = 'PARTIAL_OUTAGE';
  /**
   * This notification was generated by Google.
   */
  public const SOURCE_GOOGLE = 'GOOGLE';
  /**
   * [Deprecated] This notification was generated by Google.
   */
  public const SOURCE_NSRC_GOOGLE = 'NSRC_GOOGLE';
  /**
   * This outage notification is active. The event could be in the future,
   * present, or past. See start_time and end_time for scheduling.
   */
  public const STATE_ACTIVE = 'ACTIVE';
  /**
   * The outage associated with this notification was cancelled before the
   * outage was due to start.
   */
  public const STATE_CANCELLED = 'CANCELLED';
  /**
   * The outage associated with this notification is complete.
   */
  public const STATE_COMPLETED = 'COMPLETED';
  /**
   * [Deprecated] This outage notification is active. The event could be in the
   * future, present, or past. See start_time and end_time for scheduling.
   */
  public const STATE_NS_ACTIVE = 'NS_ACTIVE';
  /**
   * [Deprecated] The outage associated with this notification was canceled
   * before the outage was due to start.
   */
  public const STATE_NS_CANCELED = 'NS_CANCELED';
  protected $collection_key = 'affectedCircuits';
  /**
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs
   * that will be affected.
   *
   * @var string[]
   */
  public $affectedCircuits;
  /**
   * A description about the purpose of the outage.
   *
   * @var string
   */
  public $description;
  /**
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   *
   * @var string
   */
  public $endTime;
  /**
   * Form this outage is expected to take, which can take one of the following
   * values:        - OUTAGE: The Interconnect may be completely out of service
   * for    some or all of the specified window.    - PARTIAL_OUTAGE: Some
   * circuits comprising the Interconnect as a whole    should remain up, but
   * with reduced bandwidth.
   *
   * Note that the versions of this enum prefixed with "IT_" have been
   * deprecated in favor of the unprefixed values.
   *
   * @var string
   */
  public $issueType;
  /**
   * Unique identifier for this outage notification.
   *
   * @var string
   */
  public $name;
  /**
   * The party that generated this notification, which can take the following
   * value:        - GOOGLE: this notification as generated by Google.
   *
   * Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   *
   * @var string
   */
  public $source;
  /**
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   *
   * @var string
   */
  public $startTime;
  /**
   * State of this notification, which can take one of the following values:
   * - ACTIVE: This outage notification is active. The event could be in    the
   * past, present, or future. See start_time and end_time for    scheduling.
   * - CANCELLED: The outage associated with this notification was cancelled
   * before the outage was due to start.    - COMPLETED: The outage associated
   * with this notification is complete.
   *
   * Note that the versions of this enum prefixed with "NS_" have been
   * deprecated in favor of the unprefixed values.
   *
   * @var string
   */
  public $state;

  /**
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs
   * that will be affected.
   *
   * @param string[] $affectedCircuits
   */
  public function setAffectedCircuits($affectedCircuits)
  {
    $this->affectedCircuits = $affectedCircuits;
  }
  /**
   * @return string[]
   */
  public function getAffectedCircuits()
  {
    return $this->affectedCircuits;
  }
  /**
   * A description about the purpose of the outage.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   *
   * @param string $endTime
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * Form this outage is expected to take, which can take one of the following
   * values:        - OUTAGE: The Interconnect may be completely out of service
   * for    some or all of the specified window.    - PARTIAL_OUTAGE: Some
   * circuits comprising the Interconnect as a whole    should remain up, but
   * with reduced bandwidth.
   *
   * Note that the versions of this enum prefixed with "IT_" have been
   * deprecated in favor of the unprefixed values.
   *
   * Accepted values: IT_OUTAGE, IT_PARTIAL_OUTAGE, OUTAGE, PARTIAL_OUTAGE
   *
   * @param self::ISSUE_TYPE_* $issueType
   */
  public function setIssueType($issueType)
  {
    $this->issueType = $issueType;
  }
  /**
   * @return self::ISSUE_TYPE_*
   */
  public function getIssueType()
  {
    return $this->issueType;
  }
  /**
   * Unique identifier for this outage notification.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The party that generated this notification, which can take the following
   * value:        - GOOGLE: this notification as generated by Google.
   *
   * Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   *
   * Accepted values: GOOGLE, NSRC_GOOGLE
   *
   * @param self::SOURCE_* $source
   */
  public function setSource($source)
  {
    $this->source = $source;
  }
  /**
   * @return self::SOURCE_*
   */
  public function getSource()
  {
    return $this->source;
  }
  /**
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   *
   * @param string $startTime
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
  /**
   * State of this notification, which can take one of the following values:
   * - ACTIVE: This outage notification is active. The event could be in    the
   * past, present, or future. See start_time and end_time for    scheduling.
   * - CANCELLED: The outage associated with this notification was cancelled
   * before the outage was due to start.    - COMPLETED: The outage associated
   * with this notification is complete.
   *
   * Note that the versions of this enum prefixed with "NS_" have been
   * deprecated in favor of the unprefixed values.
   *
   * Accepted values: ACTIVE, CANCELLED, COMPLETED, NS_ACTIVE, NS_CANCELED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InterconnectOutageNotification::class, 'Google_Service_Compute_InterconnectOutageNotification');
