<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class FutureReservationStatusExistingMatchingUsageInfo extends \Google\Model
{
  /**
   * Count to represent min(FR total_count,
   * matching_reserved_capacity+matching_unreserved_instances)
   *
   * @var string
   */
  public $count;
  /**
   * Timestamp when the matching usage was calculated
   *
   * @var string
   */
  public $timestamp;

  /**
   * Count to represent min(FR total_count,
   * matching_reserved_capacity+matching_unreserved_instances)
   *
   * @param string $count
   */
  public function setCount($count)
  {
    $this->count = $count;
  }
  /**
   * @return string
   */
  public function getCount()
  {
    return $this->count;
  }
  /**
   * Timestamp when the matching usage was calculated
   *
   * @param string $timestamp
   */
  public function setTimestamp($timestamp)
  {
    $this->timestamp = $timestamp;
  }
  /**
   * @return string
   */
  public function getTimestamp()
  {
    return $this->timestamp;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FutureReservationStatusExistingMatchingUsageInfo::class, 'Google_Service_Compute_FutureReservationStatusExistingMatchingUsageInfo');
