<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudBuild;

class PipelineWorkspaceDeclaration extends \Google\Model
{
  /**
   * Description is a human readable string describing how the workspace will be
   * used in the Pipeline.
   *
   * @var string
   */
  public $description;
  /**
   * Name is the name of a workspace to be provided by a PipelineRun.
   *
   * @var string
   */
  public $name;
  /**
   * Optional marks a Workspace as not being required in PipelineRuns. By
   * default this field is false and so declared workspaces are required.
   *
   * @var bool
   */
  public $optional;

  /**
   * Description is a human readable string describing how the workspace will be
   * used in the Pipeline.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Name is the name of a workspace to be provided by a PipelineRun.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional marks a Workspace as not being required in PipelineRuns. By
   * default this field is false and so declared workspaces are required.
   *
   * @param bool $optional
   */
  public function setOptional($optional)
  {
    $this->optional = $optional;
  }
  /**
   * @return bool
   */
  public function getOptional()
  {
    return $this->optional;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PipelineWorkspaceDeclaration::class, 'Google_Service_CloudBuild_PipelineWorkspaceDeclaration');
