<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Batch;

class TaskGroup extends \Google\Collection
{
  /**
   * Unspecified.
   */
  public const SCHEDULING_POLICY_SCHEDULING_POLICY_UNSPECIFIED = 'SCHEDULING_POLICY_UNSPECIFIED';
  /**
   * Run Tasks as soon as resources are available. Tasks might be executed in
   * parallel depending on parallelism and task_count values.
   */
  public const SCHEDULING_POLICY_AS_SOON_AS_POSSIBLE = 'AS_SOON_AS_POSSIBLE';
  /**
   * Run Tasks sequentially with increased task index.
   */
  public const SCHEDULING_POLICY_IN_ORDER = 'IN_ORDER';
  protected $collection_key = 'taskEnvironments';
  /**
   * Output only. TaskGroup name. The system generates this field based on
   * parent Job name. For example: "projects/123456/locations/us-
   * west1/jobs/job01/taskGroups/group01".
   *
   * @var string
   */
  public $name;
  /**
   * Max number of tasks that can run in parallel. Default to min(task_count,
   * parallel tasks per job limit). See: [Job
   * Limits](https://cloud.google.com/batch/quotas#job_limits). Field
   * parallelism must be 1 if the scheduling_policy is IN_ORDER.
   *
   * @var string
   */
  public $parallelism;
  /**
   * When true, Batch will configure SSH to allow passwordless login between VMs
   * running the Batch tasks in the same TaskGroup.
   *
   * @var bool
   */
  public $permissiveSsh;
  /**
   * When true, Batch will populate a file with a list of all VMs assigned to
   * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
   * of that file. Defaults to false. The host file supports up to 1000 VMs.
   *
   * @var bool
   */
  public $requireHostsFile;
  /**
   * Optional. If not set or set to false, Batch uses the root user to execute
   * runnables. If set to true, Batch runs the runnables using a non-root user.
   * Currently, the non-root user Batch used is generated by OS Login. For more
   * information, see [About OS
   * Login](https://cloud.google.com/compute/docs/oslogin).
   *
   * @var bool
   */
  public $runAsNonRoot;
  /**
   * Scheduling policy for Tasks in the TaskGroup. The default value is
   * AS_SOON_AS_POSSIBLE.
   *
   * @var string
   */
  public $schedulingPolicy;
  /**
   * Number of Tasks in the TaskGroup. Default is 1.
   *
   * @var string
   */
  public $taskCount;
  /**
   * Max number of tasks that can be run on a VM at the same time. If not
   * specified, the system will decide a value based on available compute
   * resources on a VM and task requirements.
   *
   * @var string
   */
  public $taskCountPerNode;
  protected $taskEnvironmentsType = Environment::class;
  protected $taskEnvironmentsDataType = 'array';
  protected $taskSpecType = TaskSpec::class;
  protected $taskSpecDataType = '';

  /**
   * Output only. TaskGroup name. The system generates this field based on
   * parent Job name. For example: "projects/123456/locations/us-
   * west1/jobs/job01/taskGroups/group01".
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Max number of tasks that can run in parallel. Default to min(task_count,
   * parallel tasks per job limit). See: [Job
   * Limits](https://cloud.google.com/batch/quotas#job_limits). Field
   * parallelism must be 1 if the scheduling_policy is IN_ORDER.
   *
   * @param string $parallelism
   */
  public function setParallelism($parallelism)
  {
    $this->parallelism = $parallelism;
  }
  /**
   * @return string
   */
  public function getParallelism()
  {
    return $this->parallelism;
  }
  /**
   * When true, Batch will configure SSH to allow passwordless login between VMs
   * running the Batch tasks in the same TaskGroup.
   *
   * @param bool $permissiveSsh
   */
  public function setPermissiveSsh($permissiveSsh)
  {
    $this->permissiveSsh = $permissiveSsh;
  }
  /**
   * @return bool
   */
  public function getPermissiveSsh()
  {
    return $this->permissiveSsh;
  }
  /**
   * When true, Batch will populate a file with a list of all VMs assigned to
   * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
   * of that file. Defaults to false. The host file supports up to 1000 VMs.
   *
   * @param bool $requireHostsFile
   */
  public function setRequireHostsFile($requireHostsFile)
  {
    $this->requireHostsFile = $requireHostsFile;
  }
  /**
   * @return bool
   */
  public function getRequireHostsFile()
  {
    return $this->requireHostsFile;
  }
  /**
   * Optional. If not set or set to false, Batch uses the root user to execute
   * runnables. If set to true, Batch runs the runnables using a non-root user.
   * Currently, the non-root user Batch used is generated by OS Login. For more
   * information, see [About OS
   * Login](https://cloud.google.com/compute/docs/oslogin).
   *
   * @param bool $runAsNonRoot
   */
  public function setRunAsNonRoot($runAsNonRoot)
  {
    $this->runAsNonRoot = $runAsNonRoot;
  }
  /**
   * @return bool
   */
  public function getRunAsNonRoot()
  {
    return $this->runAsNonRoot;
  }
  /**
   * Scheduling policy for Tasks in the TaskGroup. The default value is
   * AS_SOON_AS_POSSIBLE.
   *
   * Accepted values: SCHEDULING_POLICY_UNSPECIFIED, AS_SOON_AS_POSSIBLE,
   * IN_ORDER
   *
   * @param self::SCHEDULING_POLICY_* $schedulingPolicy
   */
  public function setSchedulingPolicy($schedulingPolicy)
  {
    $this->schedulingPolicy = $schedulingPolicy;
  }
  /**
   * @return self::SCHEDULING_POLICY_*
   */
  public function getSchedulingPolicy()
  {
    return $this->schedulingPolicy;
  }
  /**
   * Number of Tasks in the TaskGroup. Default is 1.
   *
   * @param string $taskCount
   */
  public function setTaskCount($taskCount)
  {
    $this->taskCount = $taskCount;
  }
  /**
   * @return string
   */
  public function getTaskCount()
  {
    return $this->taskCount;
  }
  /**
   * Max number of tasks that can be run on a VM at the same time. If not
   * specified, the system will decide a value based on available compute
   * resources on a VM and task requirements.
   *
   * @param string $taskCountPerNode
   */
  public function setTaskCountPerNode($taskCountPerNode)
  {
    $this->taskCountPerNode = $taskCountPerNode;
  }
  /**
   * @return string
   */
  public function getTaskCountPerNode()
  {
    return $this->taskCountPerNode;
  }
  /**
   * An array of environment variable mappings, which are passed to Tasks with
   * matching indices. If task_environments is used then task_count should not
   * be specified in the request (and will be ignored). Task count will be the
   * length of task_environments. Tasks get a BATCH_TASK_INDEX and
   * BATCH_TASK_COUNT environment variable, in addition to any environment
   * variables set in task_environments, specifying the number of Tasks in the
   * Task's parent TaskGroup, and the specific Task's index in the TaskGroup (0
   * through BATCH_TASK_COUNT - 1).
   *
   * @param Environment[] $taskEnvironments
   */
  public function setTaskEnvironments($taskEnvironments)
  {
    $this->taskEnvironments = $taskEnvironments;
  }
  /**
   * @return Environment[]
   */
  public function getTaskEnvironments()
  {
    return $this->taskEnvironments;
  }
  /**
   * Required. Tasks in the group share the same task spec.
   *
   * @param TaskSpec $taskSpec
   */
  public function setTaskSpec(TaskSpec $taskSpec)
  {
    $this->taskSpec = $taskSpec;
  }
  /**
   * @return TaskSpec
   */
  public function getTaskSpec()
  {
    return $this->taskSpec;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TaskGroup::class, 'Google_Service_Batch_TaskGroup');
